'use client'

import { useEffect, useState } from 'react'
import { useCartStore } from '@/store/cart'

export function useHydrationSafeCart() {
  const [isHydrated, setIsHydrated] = useState(false)
  const cartStore = useCartStore()

  useEffect(() => {
    setIsHydrated(true)
  }, [])

  // Return safe defaults during SSR/hydration
  if (!isHydrated) {
    return {
      // Basic cart operations
      getTotalItems: () => 0,
      openCart: () => {},
      closeCart: () => {},
      toggleCart: () => {},
      items: [],
      bundles: [],
      isOpen: false,
      addItem: () => {},
      addToCart: () => {},
      removeItem: () => {},
      updateQuantity: () => {},
      clearCart: () => {},
      getTotalPrice: () => 0,
      
      // Enhanced operations
      updatePackage: () => {},
      addAddon: () => {},
      removeAddon: () => {},
      updateCustomization: () => {},
      applyPromoCode: () => false,
      removePromoCode: () => {},
      appliedPromoCode: undefined,
      promoDiscount: undefined,
      
      // Bundle operations
      addBundle: () => {},
      removeBundle: () => {},
      suggestBundles: () => [],
      
      // Enhanced calculations
      getBulkDiscount: () => 0,
      getTotalWithDiscounts: () => 0,
      getSavings: () => 0,
    }
  }

  return cartStore
}