"use client";

import React, { createContext, useContext, ReactNode, useState } from "react";


// Cart context and provider
type CartItem = {
  id: string;
  name: string;
  price: number;
  quantity: number;
  [key: string]: any;
};
type CartContextType = {
  items: CartItem[];
  addItem: (item: any) => void;
  removeItem: (id: string) => void;
  updateQuantity: (id: string, quantity: number) => void;
  clearCart: () => void;
  getTotal: () => number;
  getSubtotal: () => number;
  getTax: () => number;
  getShipping: () => number;
  getItemCount: () => number;
  openCart: () => void;
};
const CartContext = createContext<CartContextType | null>(null);


export function CartProvider({ children }: { children: ReactNode }) {
  // Example cart state (replace with your logic)
  type CartItem = {
    id: string;
    name: string;
    price: number;
    quantity: number;
    [key: string]: any;
  };
  const [items, setItems] = useState<CartItem[]>([]);

  const addItem = (item: any) => setItems((prev) => [...prev, item]);
  const removeItem = (id: string) => setItems((prev) => prev.filter((item) => item.id !== id));
  const updateQuantity = (id: string, quantity: number) =>
    setItems((prev) => prev.map((item) => (item.id === id ? { ...item, quantity } : item)));
  const clearCart = () => setItems([]);
  const getTotal = () => items.reduce((sum, item) => sum + (item.price * item.quantity), 0);
  const getSubtotal = () => getTotal();
  const getTax = () => 0;
  const getShipping = () => 0;
  const getItemCount = () => items.reduce((sum, item) => sum + item.quantity, 0);
  const openCart = () => {};

  const value = {
    items,
    addItem,
    removeItem,
    updateQuantity,
    clearCart,
    getTotal,
    getSubtotal,
    getTax,
    getShipping,
    getItemCount,
    openCart,
  };

  return <CartContext.Provider value={value}>{children}</CartContext.Provider>;
}

export function useCart() {
  const context = useContext(CartContext);
  if (!context) throw new Error("useCart must be used within CartProvider");
  return context;
}
